<title>Clicks - <?php echo e($data->duration ?? ''); ?> Seconds</title>


<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
<link rel="stylesheet" href="https://moneyupwork.com/resources/css/argon.css?v=1.1.0" type="text/css">
<link rel="stylesheet" href="https://moneyupwork.com/resources/css/myapp.css" type="text/css">
<link rel="stylesheet" href="https://moneyupwork.com/resources/css/bttn.css" type="text/css">
<?php $__env->stopSection(); ?>

<style>
    /* Overlay Styling */
    .overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        /*background: rgba(0, 0, 0, 0.7);*/
        background: red;
        color: white;
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 1000;
        display: none; /* Hidden by default */
    }

    .overlay.active {
        display: flex; /* Show overlay when 'active' class is added */
    }

    /* Centering content inside the overlay */
    .overlay-content {
        max-width: 600px; /* Max width for the content */
        width: 90%; /* Responsive width */
        padding: 20px;
        box-sizing: border-box;
        background: rgba(0, 0, 0, 0.8); /* Slightly darker background for the content box */
        border-radius: 10px;
        text-align: center;
    }

    /* Text styling */
    .overlay-text p {
        font-size: 18px;
        margin-bottom: 20px;
    }

    /* Button styling */
    .overlay-btn a {
        font-size: 16px;
        padding: 10px 20px;
    }

    /* Responsive styles */
    @media (max-width: 768px) {
        .overlay-text p {
            font-size: 14px; /* Smaller text for tablet */
        }

        .overlay-btn a {
            font-size: 14px; /* Smaller button font */
            padding: 12px 20px; /* Adjust button padding */
        }
    }

    @media (max-width: 480px) {
        .overlay-text p {
            font-size: 12px; /* Even smaller text for phones */
        }

        .overlay-btn a {
            font-size: 12px; /* Even smaller button font */
            padding: 10px 15px; /* Smaller button padding */
        }
    }
</style>
<?php $__env->startSection('user-content'); ?>
<section>
    <div class="card mt-2">
       
        <div class="card-header text-center" style="background-color: #f8f9fa; border-bottom: 2px solid #2ECC71;">
            <div class="card-title" style="font-weight: 600; color: #2ECC71; font-size: 24px; margin-bottom: 10px;">
                Click and Earning Balance: 
                <span style="color: #28a745;"><?php echo e(number_format(Auth::user()->click_earn_balance, 4)); ?> $</span>
            </div>
        
            <form action="<?php echo e(route('user.ads.bal_withdraw', Auth::id())); ?>" method="POST" style="margin-top: 15px;">
                <?php echo csrf_field(); ?>
                <div class="input-group" style="max-width: 400px; margin: 0 auto;">
                    <!-- Hidden input for withdraw balance -->
                    <input type="hidden" name="withdraw_bal" class="form-control" min="0" max="0" 
                           value="<?php echo e(number_format(Auth::user()->click_earn_balance, 4)); ?>" placeholder="Enter amount to withdraw" required>
                    
                    <button type="submit" class="btn btn-success" style="font-weight: 500; padding: 10px 20px; border-radius: 5px; margin-right: 10px;">
                        Withdraw Balance
                    </button>
                    
                    <!-- History Button with different color and margin for gap -->
                    <a href="<?php echo e(url('user/ads-history', Auth::id())); ?>" class="btn btn-info" style="font-size: 20px; padding: 15px 20px; border-radius: 5px;">
                        History
                    </a>
                </div>
            </form>

       
        </div>


  
        <div class="container my-2">
            <!-- Table Wrapper -->
         <div class="row p-2">
            <?php $__empty_1 = true; $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
               <?php if(!in_array($data->slug, $work_complates)): ?>
                    <div class="col-md-3 col-6 mb-6">
                        <div class="card shadow-sm">
                            <!-- Card Header -->
                            <div class="card-header bg-primary text-white text-center">
                                <h5 class="card-title mb-0">Earned: <strong>$<?php echo e(number_format($data->cost / $data->worker, 4)); ?></strong></h5>
                            </div>
        
                            <!-- Card Body -->
                            <div class="card-body">
                                <p class="mb-2"><strong>ID:</strong> <?php echo e($data->slug); ?></p>
                                <p class="mb-3"><strong>Waiting Time:</strong>
                                    <span id="duration-<?php echo e($data->id); ?>"><?php echo e($data->duration); ?></span> Seconds
                                </p>
                               <!-- Updated Button with Link -->
                                <?php if($data->userID != Auth::user()->id): ?>
                                   <a href="<?php echo e($data->adsLink); ?>"
                                      id="adsLink"
                                      target="_blank"
                                      class="btn btn-success"
                                      style="font-size: 10px; padding: 5px 5px;"
                                      onclick="startCountdown(<?php echo e($data->id); ?>, <?php echo e($data->duration); ?>, '<?php echo e(url('user/ads-status-update', $data->id)); ?>')">
                                       Click Here
                                   </a>
                                <?php else: ?>
                                   <button class="btn btn-danger" style="font-size: 10px; padding: 5px 5px;" disabled>
                                       This Is Your Ad
                                   </button>
                                <?php endif; ?>
        
                               <!-- Overlay to block interaction -->
                           <div id="overlay" class="overlay">
                                <div class="overlay-content">
                                    <div class="overlay-text">
                                        <p>আপনার এডস দেখার নির্দিষ্ট সময় এখনও শেষ হয়নি। নির্দিষ্ট সময় পর্যন্ত এডস না দেখলে আপনার ব্যালেন্স যুক্ত হবে না। এডস দেখতে নিচের বাটনে ক্লিক করুন।</p>
                                    </div>
                                    <div class="overlay-btn">
                                        <a href="<?php echo e(url('user/ads-click_create')); ?>"
                                           class="btn btn-success">
                                            Click Here
                                        </a>
                                    </div>
                                </div>
                            </div>
                            </div>
        
                            <!-- Card Footer -->
                            <div class="card-footer text-muted text-center" style="font-size: 10px;">
                                Ads by: <strong><?php echo e($data->user_name); ?></strong>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12 text-center">
                    <div class="alert alert-warning">
                        <strong>Sorry, no ads are available for you.</strong>
                    </div>
                </div>
            <?php endif; ?>
        </div>


        </div>
    </div>
</section>

<script>
let countdownInterval;
let remainingTime;
let durationElement;
let countdownStarted = false; // Flag to track if countdown has started
let originalTitle = document.title; // Store the original page title

function startCountdown(id, duration, updateUrl) {
    durationElement = document.getElementById(`duration-${id}`);
    remainingTime = duration;

    // Check if there is a remaining time stored in sessionStorage and resume it
    if (sessionStorage.getItem(`remainingTime-${id}`)) {
        remainingTime = parseInt(sessionStorage.getItem(`remainingTime-${id}`));
    }

    // Update the title to show the countdown
    document.title = `Clicks - ${remainingTime} Seconds remaining`;

    // Show the overlay to block interactions
    document.getElementById("overlay").classList.add("active");

    // Function to handle countdown logic
    function updateCountdown() {
        if (remainingTime > 0) {
            remainingTime--;
            durationElement.textContent = remainingTime;
            document.title = `Clicks - ${remainingTime} Seconds remaining`;
            sessionStorage.setItem(`remainingTime-${id}`, remainingTime);
        } else {
            clearInterval(countdownInterval);
            enableLink(id, updateUrl);
            completeCountdown(updateUrl, id);
        }
    }

    // Start the countdown only if not paused
    if (!countdownStarted) {
        countdownInterval = setInterval(updateCountdown, 1000);
        countdownStarted = true; // Mark countdown as started
    }

    // Block the user from clicking the link until countdown is over
    const linkElement = document.querySelector(`a[href='${updateUrl}']`);
    if (linkElement) {
        linkElement.addEventListener('click', function (event) {
            if (remainingTime > 0) {
                event.preventDefault(); // Prevent link navigation
                alert(`Please stay on the page for ${remainingTime} seconds before leaving.`);
            }
        });
    }

    // Listen for both mouse and touch events to pause the countdown
    document.addEventListener('mousemove', pauseCountdown);
    document.addEventListener('touchstart', pauseCountdown);

    // Resume countdown when interaction ends
    document.addEventListener('mouseleave', resumeCountdown);
    document.addEventListener('touchend', resumeCountdown);
}

// Function to enable the link after the countdown is finished
function enableLink(id, updateUrl) {
    const linkElement = document.querySelector(`a[href='${updateUrl}']`);
    if (linkElement) {
        linkElement.removeAttribute('onclick'); // Remove the onclick handler to allow navigation
        linkElement.style.pointerEvents = 'auto'; // Enable the link (makes it clickable)
        linkElement.style.cursor = 'pointer'; // Change cursor to pointer
        linkElement.textContent = 'Click Here'; // Change the button text to indicate it's clickable
    }

    // Remove the overlay when countdown ends
    document.getElementById("overlay").classList.remove("active");
}

// Function to mark the countdown as complete and send the request to update status
function completeCountdown(updateUrl, id) {
    fetch(updateUrl, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({ 
        status: 1
        })
    })
        .then(response => {
            if (response.ok) {
                console.log('Status updated successfully');
                location.reload();
            } else {
                console.error('Failed to update status');
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });

    // Reset the page title and remove stored time when the countdown completes
    document.title = originalTitle;
    sessionStorage.removeItem(`remainingTime-${id}`);
}

// Pause countdown when mouse or touch events are triggered
function pauseCountdown() {
    clearInterval(countdownInterval); // Stop the countdown
    // Optionally, you can update the title to reflect that the countdown is paused
    document.title = `Countdown Paused - ${remainingTime} Seconds remaining`;
}

// Resume countdown when mouse or touch events are no longer present
function resumeCountdown() {
    if (remainingTime > 0) {
        countdownInterval = setInterval(updateCountdown, 1000); // Restart countdown
    }
}

// Store the remaining time in sessionStorage so it persists after page reload
window.addEventListener('beforeunload', function () {
    sessionStorage.setItem('remainingTime', remainingTime);
});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mhmaicro/public_html/resources/views/user/pages/ads_create.blade.php ENDPATH**/ ?>